"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.timeFormats = timeFormats;
exports.parseDateTime = parseDateTime;
exports.setZone = setZone;
const luxon_1 = require("luxon");
const String_1 = require("./String");
const Timezones_1 = require("./Timezones");
const TimeFmts = [
    // I haven't seen times without padded hours, minutes, or seconds in the
    // wild (yet), so those aren't handled here:
    { fmt: "HH:mm:ss.u", unsetMilliseconds: false },
    { fmt: "HH:mm:ss", unsetMilliseconds: true },
    { fmt: "HH:mm", unsetMilliseconds: true },
];
function* timeFormats(args) {
    var _a;
    const inferredZone = (0, String_1.notBlank)(args.defaultZone);
    for (const prefix of (_a = args.formatPrefixes) !== null && _a !== void 0 ? _a : [""]) {
        for (const timeFmt of TimeFmts) {
            yield {
                fmt: prefix + timeFmt.fmt,
                zone: args.defaultZone,
                unsetMilliseconds: timeFmt.unsetMilliseconds,
                inferredZone,
            };
        }
    }
}
function parseDateTime(text, fmts) {
    var _a, _b, _c, _d;
    const s = (0, String_1.toS)(text).trim();
    if (s.length === 0)
        return;
    const extractedZone = (0, Timezones_1.extractZone)(s);
    const input = (_a = extractedZone === null || extractedZone === void 0 ? void 0 : extractedZone.leftovers) !== null && _a !== void 0 ? _a : s;
    for (const ea of fmts) {
        const dt = luxon_1.DateTime.fromFormat(input, ea.fmt, {
            setZone: true,
            zone: (_c = (_b = extractedZone === null || extractedZone === void 0 ? void 0 : extractedZone.tz) !== null && _b !== void 0 ? _b : ea.zone) !== null && _c !== void 0 ? _c : Timezones_1.UnsetZone,
        });
        if (dt == null || !dt.isValid)
            continue;
        const unsetZone = (extractedZone === null || extractedZone === void 0 ? void 0 : extractedZone.tz) == null && (dt.zone == null || dt.zone === Timezones_1.UnsetZone);
        let inferredZone = (extractedZone === null || extractedZone === void 0 ? void 0 : extractedZone.tz) != null || unsetZone ? false : ea.inferredZone;
        if (inferredZone == null) {
            // this is pretty miserable, but luxon doesn't expose _how_ it got
            // the zone, so we have to resort to this hack to see if the zone
            // is inferred:
            const dt2 = luxon_1.DateTime.fromFormat(input, ea.fmt, { setZone: true });
            inferredZone = dt.zone !== dt2.zone;
        }
        return {
            dt,
            fmt: ea.fmt,
            unsetZone,
            inferredZone,
            input,
            unsetMilliseconds: (_d = ea.unsetMilliseconds) !== null && _d !== void 0 ? _d : false,
        };
    }
    return;
}
function setZone(args) {
    // This is a bit tricky... We want to keep the local time and just _say_ it
    // was in the zone of the image **but only if we don't already have a zone.**
    // If we _do_ have a zone, assume it was already converted by ExifTool into
    // (probably the system) timezone, which means _don't_ `keepLocalTime`.
    return args.src.setZone(args.zone, {
        keepLocalTime: !args.srcHasZone,
        ...args.opts,
    });
}
//# sourceMappingURL=TimeParsing.js.map