"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isNumber = isNumber;
exports.toFloat = toFloat;
exports.toInt = toInt;
function isNumber(n) {
    return typeof n === "number" && isFinite(n);
}
function toFloat(n) {
    if (n == null)
        return;
    if (isNumber(n))
        return n;
    try {
        return parseFloat(String(n).trim());
    }
    catch {
        return undefined;
    }
}
function toInt(n) {
    if (n == null)
        return;
    if (isNumber(n)) {
        // we don't round here, because parsing floats also doesn't round.
        return Math.floor(n);
    }
    try {
        return parseInt(String(n).trim());
    }
    catch {
        return undefined;
    }
}
//# sourceMappingURL=Number.js.map