"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.lazy = lazy;
function lazy(thunk) {
    let invoked = false;
    let result;
    let error;
    return () => {
        if (!invoked) {
            try {
                invoked = true;
                result = thunk();
            }
            catch (e) {
                error = e;
                throw e;
            }
        }
        if (error != null)
            throw error;
        return result;
    };
}
//# sourceMappingURL=Lazy.js.map