"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isFileTag = isFileTag;
const Object_1 = require("./Object");
const FileTagNames = (0, Object_1.keysOf)({
    BMPVersion: true,
    BitsPerSample: true,
    ColorComponents: true,
    CurrentIPTCDigest: true,
    Directory: true,
    EncodingProcess: true,
    ExifByteOrder: true,
    FileAccessDate: true,
    FileCreateDate: true,
    FileInodeChangeDate: true,
    FileModifyDate: true,
    FileName: true,
    FilePermissions: true,
    FileSize: true,
    FileType: true,
    FileTypeExtension: true,
    ImageDataMD5: true,
    ImageHeight: true,
    ImageWidth: true,
    MIMEType: true,
    NumColors: true,
    NumImportantColors: true,
    PixelsPerMeterX: true,
    PixelsPerMeterY: true,
    Planes: true,
    YCbCrSubSampling: true,
});
/**
 * Is the given tag name intrinsic to the content of a given file? In other
 * words, is it not an artifact of a metadata field?
 */
function isFileTag(name) {
    return FileTagNames.includes(name);
}
//# sourceMappingURL=FileTags.js.map