"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultExifToolOptions = exports.ConsoleLogger = void 0;
exports.defaultAdjustTimeZoneIfDaylightSavings = defaultAdjustTimeZoneIfDaylightSavings;
const bc = __importStar(require("batch-cluster"));
const node_util_1 = require("node:util");
const Boolean_1 = require("./Boolean");
const CapturedAtTagNames_1 = require("./CapturedAtTagNames");
const DefaultExiftoolArgs_1 = require("./DefaultExiftoolArgs");
const DefaultMaxProcs_1 = require("./DefaultMaxProcs");
const ExiftoolPath_1 = require("./ExiftoolPath");
const GeoTz_1 = require("./GeoTz");
const IsWin32_1 = require("./IsWin32");
const VersionTask_1 = require("./VersionTask");
const _debuglog = (0, node_util_1.debuglog)("exiftool-vendored");
function noop() { }
exports.ConsoleLogger = {
    trace: noop,
    debug: _debuglog,
    info: _debuglog,
    warn: console.warn,
    error: console.error,
};
function logger() {
    return (0, node_util_1.debuglog)("exiftool-vendored").enabled ? exports.ConsoleLogger : bc.NoLogger;
}
/**
 * Default values for `ExifToolOptions`, except for `processFactory` (which is
 * created by the ExifTool constructor)
 */
exports.DefaultExifToolOptions = Object.freeze({
    ...new bc.BatchClusterOptions(),
    maxProcs: DefaultMaxProcs_1.DefaultMaxProcs,
    maxTasksPerProcess: 500,
    spawnTimeoutMillis: 30000,
    // see https://github.com/photostructure/exiftool-vendored.js/issues/34 :
    taskTimeoutMillis: 20000,
    onIdleIntervalMillis: 2000,
    taskRetries: 1,
    exiftoolPath: ExiftoolPath_1.exiftoolPath,
    exiftoolArgs: DefaultExiftoolArgs_1.DefaultExiftoolArgs,
    exiftoolEnv: {},
    checkPerl: !(0, IsWin32_1.isWin32)(),
    pass: "{ready}",
    fail: "{ready}",
    exitCommand: "-stay_open\nFalse\n",
    versionCommand: new VersionTask_1.VersionTask().command,
    healthCheckIntervalMillis: 30000,
    healthCheckCommand: "-ver\n-execute\n",
    backfillTimezones: true,
    defaultVideosToUTC: true,
    geoTz: GeoTz_1.geoTz,
    geolocation: false,
    ignoreZeroZeroLatLon: true,
    ignoreMinorErrors: true,
    imageHashType: false,
    includeImageDataMD5: undefined,
    inferTimezoneFromDatestamps: false, // to retain prior behavior
    inferTimezoneFromDatestampTags: [...CapturedAtTagNames_1.CapturedAtTagNames],
    inferTimezoneFromTimeStamp: false, // to retain prior behavior
    logger,
    numericTags: [
        "*Duration*",
        "GPSAltitude",
        "GPSLatitude",
        "GPSLongitude",
        "GPSPosition",
        "Orientation",
        // NOT Rotation! Rotation can be encoded as degrees rotated clockwise, or a
        // EXIF-Orientation string (!!). If we ask ExifTool for numeric rotations of HEICs,
        // we get "3" (when it means "Rotate 90 CW"):
        // $ exiftool -j -Rotation -Orientation IMG_6947.HEIC
        // [{
        //   "Rotation": "Rotate 90 CW",
        //   "Orientation": "Rotate 90 CW"
        // }]
        // $ exiftool -j -Rotation# -Orientation# IMG_6947.HEIC
        // [{
        //   "Rotation": 3,   // < WTH is this? 3 means 180º (!?)
        //   "Orientation": 6 // < expected
        // }]
    ],
    useMWG: false,
    struct: 1,
    readArgs: ["-fast"],
    writeArgs: [],
    adjustTimeZoneIfDaylightSavings: defaultAdjustTimeZoneIfDaylightSavings,
    preferTimezoneInferenceFromGps: false, // to retain prior behavior
});
/**
 * @see https://github.com/photostructure/exiftool-vendored.js/issues/215
 */
function defaultAdjustTimeZoneIfDaylightSavings(t) {
    // `DaylightSavings` may be "Yes" or `true`:
    return true === (0, Boolean_1.toBoolean)(t.DaylightSavings) &&
        // Daggum Nikon likes "FS-Nikon", "Nikon", "NIKON", and "NIKON CORPORATION"
        /\bnikon\b/i.test(String(t.Make))
        ? 60
        : undefined;
}
//# sourceMappingURL=DefaultExifToolOptions.js.map