"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.which = which;
const node_fs_1 = require("node:fs");
const promises_1 = require("node:fs/promises");
const node_path_1 = require("node:path");
const node_process_1 = require("node:process");
const IsWin32_1 = require("./IsWin32");
const String_1 = require("./String");
async function which(binaryOrPath) {
    if ((0, node_path_1.isAbsolute)(binaryOrPath) && (await canRX(binaryOrPath))) {
        return binaryOrPath;
    }
    const base = (0, node_path_1.basename)(binaryOrPath);
    for (const dir of (0, String_1.toS)(node_process_1.env.PATH).split(node_path_1.delimiter)) {
        const fullPath = (0, node_path_1.join)(dir, base);
        if (await canRX(fullPath)) {
            return fullPath;
        }
    }
    return;
}
async function canRX(fullpath) {
    if ((0, IsWin32_1.isWin32)())
        return (0, node_fs_1.existsSync)(fullpath);
    try {
        await (0, promises_1.access)(fullpath, node_fs_1.constants.R_OK | node_fs_1.constants.X_OK);
        return true;
    }
    catch {
        return false;
    }
}
//# sourceMappingURL=Which.js.map