"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RewriteAllTagsTask = void 0;
const _path = __importStar(require("node:path"));
const Array_1 = require("./Array");
const ExifToolTask_1 = require("./ExifToolTask");
const FilenameCharsetArgs_1 = require("./FilenameCharsetArgs");
class RewriteAllTagsTask extends ExifToolTask_1.ExifToolTask {
    constructor(args, options) {
        super(args, options);
    }
    static for(imgSrc, imgDest, opts) {
        // -all= -tagsfromfile @ -all:all -unsafe -icc_profile bad.jpg
        const args = (0, Array_1.compact)([
            ...FilenameCharsetArgs_1.Utf8FilenameCharsetArgs,
            "-all=",
            "-tagsfromfile",
            "@",
            "-all:all",
            "-unsafe",
            "-icc_profile",
            opts.allowMakerNoteRepair ? "-F" : undefined,
            "-out",
            _path.resolve(imgDest),
            _path.resolve(imgSrc),
        ]);
        return new RewriteAllTagsTask(args, opts);
    }
    parse(data, error) {
        var _a;
        if (error != null) {
            const str = String(error);
            // Ignore warnings:
            if (str.match(/\berror\b/i) != null && !str.match(/\bwarning\b/i)) {
                throw error;
            }
        }
        if (null == data.match(/^\s*1 image files creat/i)) {
            throw (error !== null && error !== void 0 ? error : new Error((_a = data.trim().split("\n")[0]) !== null && _a !== void 0 ? _a : "Missing expected status message"));
        }
    }
}
exports.RewriteAllTagsTask = RewriteAllTagsTask;
//# sourceMappingURL=RewriteAllTagsTask.js.map