"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _ExifToolTask_instances, _ExifToolTask_parser;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExifToolTask = void 0;
const bc = __importStar(require("batch-cluster"));
const IsWarning_1 = require("./IsWarning");
const String_1 = require("./String");
const BadPerlInstallationRE = /Can't locate \S+ in @INC/i;
class ExifToolTask extends bc.Task {
    static renderCommand(args, options) {
        const result = args.filter((ea) => !(0, String_1.blank)(ea));
        if ((options === null || options === void 0 ? void 0 : options.ignoreMinorErrors) === true) {
            result.push("-ignoreMinorErrors");
        }
        result.push("-execute");
        return result.join("\n") + "\n";
    }
    constructor(args, options) {
        super(ExifToolTask.renderCommand(args, options), (stdout, stderr, passed) => __classPrivateFieldGet(this, _ExifToolTask_instances, "m", _ExifToolTask_parser).call(this, stdout, stderr, passed));
        _ExifToolTask_instances.add(this);
        this.args = args;
        this.options = options;
        this.errors = [];
        this.warnings = [];
    }
    onStderr(buf) {
        if (BadPerlInstallationRE.test(buf.toString())) {
            // This isn't an error we can recover from: there's a Perl module that
            // needs to be installed. See
            // https://github.com/photostructure/exiftool-vendored.js/issues/168 for
            // details.
            throw new Error(buf.toString());
        }
        super.onStderr(buf);
    }
}
exports.ExifToolTask = ExifToolTask;
_ExifToolTask_instances = new WeakSet(), _ExifToolTask_parser = function _ExifToolTask_parser(stdout, stderr, passed) {
    let error;
    if ((0, String_1.notBlank)(stderr) || !passed) {
        for (const line of (0, String_1.splitLines)(stderr !== null && stderr !== void 0 ? stderr : "")) {
            if ((0, IsWarning_1.isWarning)(line)) {
                this.warnings.push(line);
            }
            else if (/error|warning/i.test(line)) {
                this.errors.push(line);
                // new Error() will add a "Error: " prefix:
                error !== null && error !== void 0 ? error : (error = new Error(line.replace(/^error: /i, "")));
            }
        }
    }
    return this.parse(stdout, error);
};
//# sourceMappingURL=ExifToolTask.js.map